#include "os.h"
#include "OsEvent.hpp"

OS_Event::OS_Event()
{
    m_iEvent = 0;
    m_iHandle = 0;
    m_iReceved = 0;
}

void OS_Event::Init(UINT8 initial_flag)
{
   m_iEvent = initial_flag ;
   m_iHandle = OsQueueCreate(1, 1 );

   if (initial_flag != 0) {
       Send(10, initial_flag) ;
   }
}

UINT32 OS_Event::Receive(UINT32 timeout, UINT8 no_consume)
{
    m_iReceved = 0;
    return OsDequeueWait(m_iHandle, (void *)&m_iReceved, timeout, (UINT32)no_consume) ;
}

UINT32 OS_Event::Send(UINT32 timeout, UINT8 EventValue)
{
   m_iEvent = EventValue ;
   return OsQueue(m_iHandle, (void *)&m_iEvent, timeout ) ;
}



